<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:include href="master.xsl"/>
	
	<xsl:template match="data">
		
			<table name="ReportData" id="ReportData" cellpadding="0" cellspacing="0" class="data_TABLE"> 
				<xsl:apply-templates />
			</table>

		<br />
	</xsl:template>

	<xsl:template match="header">
		<tr>
			<xsl:for-each select="column">
				<th><xsl:value-of select="." /></th>
			</xsl:for-each>
		</tr>
	</xsl:template>
		
	<xsl:template match="row">
		<tr>
			<xsl:attribute name="class"><xsl:value-of select="@class" /></xsl:attribute>
			<xsl:apply-templates />
		</tr>
	</xsl:template>
	
	<xsl:template match="row/*">
		<td>
		    <xsl:attribute name="class">data_TD <xsl:value-of select="@class" /></xsl:attribute>		    
			<xsl:value-of select="." />
		</td>
	</xsl:template>	

	<xsl:template match="form" >
		<div id="FormContainer">
			<form id="formFilter" method="post">
				<xsl:attribute name="action"><xsl:value-of select="action" /></xsl:attribute>
				
				<input type="hidden" name="formName" id="formName" value="formFilter"/>
				<input type="hidden" name="actionController" id="actionController" value="submit"/>	
				<input type="hidden" name="formToken" id="formToken">
					<xsl:attribute name="value"><xsl:value-of select="token" /></xsl:attribute>
				</input>
				
				<div style="height:80px; vertical-align: middle; text-align: center;">
					<div style="height:20px; vertical-align: baseline; text-align: right; border-bottom: 1px solid rgb(192,0,0);">
						<a href="javascript:sendFormFilterLogout();">
							Изход
						</a> 
					</div>
					<div style="height:10px"></div>
					<label class="formLabel" for="selectStore">Изберете склад : </label>
	
					<select class="formElement" id="selectStore" name="selectStore">
						<option value="" selected="selected"></option>
						<xsl:for-each select="stores/store">
							<option >
								<xsl:attribute name="value"><xsl:value-of select="@value" /></xsl:attribute>
								 <xsl:if test="@selected='true'">
								 	<xsl:attribute name="selected"><xsl:value-of select="@selected" /></xsl:attribute>
								 </xsl:if>
								
								<xsl:value-of select="." />
							</option>
						</xsl:for-each>
					</select>
					
					<label class="formLabel" for="begDate"> От дата : </label>
					<input type="text" readonly="readonly" name="begDate" id="begDate" class="formElement"
						onFocus="displayCalendar(document.forms.formFilter.begDate,'yyyy-mm-dd',this)"
						onClick="displayCalendar(document.forms.formFilter.begDate,'yyyy-mm-dd',this)"
						onBlur="closeCalendar" >
						<xsl:attribute name="value"><xsl:value-of select="begDate" /></xsl:attribute>
					</input>
					<label class="formLabel" for="endDate"> До дата : </label>
					<input type="text" readonly="readonly" name="endDate" id="endDate" class="formElement"
						onFocus="displayCalendar(document.forms.formFilter.endDate,'yyyy-mm-dd',this)"
						onClick="displayCalendar(document.forms.formFilter.endDate,'yyyy-mm-dd',this)"
						onBlur="closeCalendar" >
						<xsl:attribute name="value"><xsl:value-of select="endDate" /></xsl:attribute>
					</input>
					
					<input id="saveForm" class="buttonText" type="button" name="saveForm" value="Справка" onClick="sendFormFilter(this.form);"/>
					<input id="showStock" class="buttonText" type="button" name="showStock" value="Наличност" onClick="sendFormFilterStock(this.form);"/>
					<input id="showBanderol" class="buttonText" type="button" name="showBanderol" value="Бандероли" onClick="sendFormFilterBanderol(this.form);"/>
					<div id="errorMessage" class="errorMessage" style="display:none;"></div>
				</div>
			</form>
		</div>
	</xsl:template>
	
</xsl:stylesheet>